﻿using HarmonyLib;
using NewHorizons.Utility;
using OWML.Common;
using OWML.ModHelper;
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using UnityEngine;
using NewHorizons.Utility.Files;
using System.Linq;
using NewHorizons.Utility.OWML;
using NewHorizons.Components.Orbital;
using Autodesk.Fbx;
using Epic.OnlineServices;
using NewHorizons.Utility.OuterWilds;
using NewHorizons.Handlers;
using NewHorizons.External.Modules.VariableSize;
using NewHorizons.Components;

namespace IntactMod2
{
    public class IntactMod2 : ModBehaviour
    {
        public static IntactMod2 Instance;

        private bool _hasEchoes;

        private void Awake()
        {
            Instance = this;
            Harmony.CreateAndPatchAll(Assembly.GetExecutingAssembly());
        }

        private void Update()
        {
            TimeLoop._loopDuration = 2820;
            if (TimeLoop.GetMinutesElapsed() > 44) TimeLoop.SetSecondsRemaining(2820);

        }

        public void FixedUpdate()
        {

        }

        private static bool IsEntitlementsManagerReady()
        {
            return EntitlementsManager.IsDlcOwned() != EntitlementsManager.AsyncOwnershipStatus.NotReady;
        }
        private static bool CheckForDLC()
        {
            return EntitlementsManager.IsDlcOwned() == EntitlementsManager.AsyncOwnershipStatus.Owned;
        }


        private void Start()
        {
            // Starting here, you'll have access to OWML's mod helper.
            ModHelper.Console.WriteLine($"My mod {nameof(IntactMod2)} is loaded!", MessageType.Success);

            // Get the New Horizons API and load configs
            var newHorizons = ModHelper.Interaction.TryGetModApi<INewHorizons>("xen.NewHorizons");
            newHorizons.LoadConfigs(this);

            // Example of accessing game code.
            LoadManager.OnCompleteSceneLoad += (scene, loadScene) =>
            {
                if (loadScene != OWScene.SolarSystem) return;
                ModHelper.Console.WriteLine("Loaded into solar system!", MessageType.Success);

                Destroy(obj: GameObject.Find("FocalBody/Sector_HGT").GetComponent<EffectRuleset>());
                Destroy(obj: GameObject.Find("FakeCannonBarrel_Body (1)/Structure_NOM_OrbitalProbeCannon_Proxy"));
                Destroy(obj: GameObject.Find("FakeCannonMuzzle_Body (1)/Structure_NOM_OrbitalProbeCannon_Proxy"));
                Destroy(obj: GameObject.Find("GiantsDeep_Body/Sector_GD/Sector_GDInterior/Sector_GDCore/Sector_Module_Sunken/Interactables_Module_Sunken/Prefab_NOM_RemoteViewer (1)"));
                Destroy(obj: GameObject.Find("SS_Debris_Body/Structure_NOM_SunStation_Debris_Small"));
                Destroy(obj: GameObject.Find("SS_Debris_Body/Structure_NOM_SunStation_Debris_Big"));

                Destroy(obj: GameObject.Find("TowerTwin_Body/SandSphere_Draining"));
                Destroy(obj: GameObject.Find("TowerTwin_Body/SandSphere_Draining").GetComponent<SandLevelController>());
                Destroy(obj: GameObject.Find("FocalBody/HourglassTwinsEffects").GetComponent<HourglassTwinsShaderController>());

                ModHelper.Events.Unity.RunWhen(IsEntitlementsManagerReady, () => _hasEchoes = CheckForDLC());


                SearchUtilities.Find("Skybox/Starfield").GetComponent<StarfieldController>().enabled = false;
                var chert = SearchUtilities.Find("CaveTwin_Body/Sector_CaveTwin/Sector_NorthHemisphere/Sector_NorthSurface/Sector_Lakebed/Interactables_Lakebed/Traveller_HEA_Chert").GetComponent<ChertTravelerController>();
                chert._nervousTime = 51;
                chert._panicTime = 52;
                chert._catatonicTime = 53;

                var sunController = GameObject.Find("Sun_Body").GetComponent<SunController>();
                sunController._progressionEndTime = 50;
                sunController._progressionStartTime = 50;
                sunController._scaleEndTime = 50;
                sunController._scaleStartTime = 50;

                var miniScale = new Vector3(0.05f, 0.05f, 0.05f);

                var anglerNest = SearchUtilities.Find("DB_AnglerNestDimension_Body/Sector_AnglerNestDimension/Interactables_AnglerNestDimension/UNSORTED");
                foreach (var anglerfish1 in anglerNest.GetComponentsInChildren<AnglerfishController>())
                {
                    anglerfish1.transform.localScale = miniScale;
                }
                var escapePodDimension = SearchUtilities.Find("DB_EscapePodDimension_Body/Sector_EscapePodDimension/Interactables_EscapePodDimension/UNSORTED");
                foreach (var anglerfish2 in escapePodDimension.GetComponentsInChildren<AnglerfishController>())
                {
                    anglerfish2.transform.localScale = miniScale;
                }
                var exitOnlyAnglerfish = SearchUtilities.Find("DB_ExitOnlyDimension_Body/Sector_ExitOnlyDimension/Interactables_ExitOnlyDimension/Anglerfish_Body");
                exitOnlyAnglerfish.transform.localScale = miniScale;

                var hubAnglerfish = SearchUtilities.Find("DB_HubDimension_Body/Sector_HubDimension/Interactables_HubDimension/Anglerfish_Body");
                hubAnglerfish.transform.localScale = miniScale;

                GlobalMessenger.AddListener("FinishOpenEyes", OnEyesOpened);
            };
        }


        private void Destroy()
        {
            GlobalMessenger.RemoveListener("FinishOpenEyes", OnEyesOpened);
        }

        private void OnEyesOpened()
        {
            if (_hasEchoes)
            {
                Destroy(obj: GameObject.Find("RingWorld_Body").GetComponent<RingWorldController>());
            }
        }
    }
 
}
